;DriveCkA Disk Drive checking Utility
;
;Will read and re-write all sectors of a drive,
;or just those requested!
;Will not damage data on the device!
;
ORG5200H
;
KFLAG$EQU4423H;LDOS Keyin Flags
RDSECTEQU4777H;Read Sector call
WRSECTEQU4763H;Write Sector call
RDSSECTEQU4B45H;Read DIR sector call
WRPROTEQU4768H;Write DIR sector call
@EXITEQU402DH
@ERROREQU4409H
@DSPLYEQU4467H
@CKDRVEQU44B8H;check disk drive status call
@KEYINEQU40H
@PARAMEQU4476H
@PAUSEEQU60H;Delay call in ROM
GETDCTEQU478FH;gets dct address into IY
DIVEAEQU4B7BH;Divide E/A routine
SELECTEQU4754H;select a new drive
VERIFYEQU4772H;Verify sector call
;
;Initialization Portion
;
DRIVECKLDSP,STACK;set stack
LDDE,PTABLE;point to param table
CALL@PARAM
JPNZ,PERROR
LDHL,MSG1;Title display
CALL@DSPLY
LDA,(KFLAG$);Reset LDOS
AND0F0H;Keyboard Key flags
LD(KFLAG$),A
LDHL,0FFFFH
DRVEQU$-2
LDA,L
CP0FFH
JRZ,DJP1
LDA,L;get input drive #
ADDA,30H;make input ascii
LDHL,(4020H);get curposn
LD(HL),A;print drive # to crt
JRDJP2
DJP1LDB,1;allow 1 char input
LDHL,BUFFR;put into sector buffer
CALL@KEYIN;get drive #
JPC,ABORT;detect <BREAK)
LDA,(HL);get char input
DJP2SUB30H;offset to 0-9
JPM,INERR;bad input!
CP9;valid only if <9
JPP,INERR
LDC,A;c=logical drive #
LD(DRIVE),A
CALL@CKDRV;verify drive is there!
JRNZ,DEVERR;Drive not ready!
JPC,DEVERR;Write protected!
CALLGETDCT;get DCT entry in IY
LDA,(IY+3);get drive flags
BIT7,A;Soft write protect?
JRNZ,DEVERR;Yes!
LDA,(IY+6);get top cyl #
LD(HICYL),A;save it
LDA,(IY+9);Get DIR sector #
LD(DCYL),A;save it too.
LDA,(IY+7);get # sectors/cyl
LDB,A
LDA,(IY+4);get 2-side bit
BIT5,A
LDA,B;restore sector count
JRZ,IJ1;skip if 1 sided
SLAA;double sector count
INCA;2nd side correction
IJ1LD(HISECT),A;save it
LDHL,00EFH;param goes here
HIGHEQU$-2
LDA,L;get input if any
CP0EFH;Entered?
JRZ,J1;default if not
CALLCKPAR;check param is ok
LD(HI),A;set selected high cyl #
JRJ2
J1LDA,(HICYL);get top cyl #
LD(HI),A;set top cyl to check
J2LDHL,00EFH;storage for low cyl #
LOEQU$-2
LDA,L
CP0EFH;Entered?
JRZ,J3;default if not specified
CALLCKPAR;verify good param
LD(LOW),A;save it
JRSTART
J3LDA,0;set start track to 0
LD(LOW),A
JRSTART
;
;Error Handlers
;
INERRLDHL,INMSG;Print input error msg
CALL@DSPLY
LDHL,0FFFFH;remove faulty param
LD(DRV),HL;input if any
PUSHBC
LDBC,0FFFFH;delay count
CALL@PAUSE
POPBC
JPDRIVECK
DEVERRLDHL,DEVMSG;Print device error msg
CALL@DSPLY
JP@EXIT;Terminate program
PERRORLDHL,PERM;Param error msg
CALL@DSPLY
ABORTLDHL,ABORTM
CALL@DSPLY
JP@EXIT
;
;Register Setup Code
;
STARTLDA,(DRIVE);get drive #
LDC,A;into C
LDDE,0FE00H;Set false cyl # & sect 0
LDHL,BUFFR;Sector Buffer
CALLNEXTRK2;set actual cyl #
;also sets #'s into Msg
CALLSELECT;Select new drive
;*:*:*
;Sector checking loop.
;*:*:*
LOOP1LDA,(HISECT);get highest sector #
INCA;correct for sector 0
CPE;Past last sector?
CALLZ,NEXTRK;goto next track if so.
CALLRP;print msg
LDA,(DCYL);check for
CPD;DIR cylinder.
JRZ,DREAD;read prot sector if so.
CALLRDSECT;read sector into buffer
RET1JRNZ,RERROR;detect error
CALLCKKEY;check for <BREAK>
CALLWP;msg
LDA,(DCYL);check for DIR cyl.
CPD
JRZ,DWRITE;Write prot if DIR cyl.
CALLWRSECT
RET2JRNZ,WERROR;Detect error
CALLVERSEC;Verify sector if wished.
INCE;Advance to next sector.
JRLOOP1;loop to check all.
;
;Increment and Validity Check Cylinder Code
;
NEXTRKLDE,0;set 1st sector
INCD;bump cyl counter
LDA,(HI);CHECK FOR
INCA
CPD;past top cylinder.
RETNZ;ok so do cyl.
NEXTRK2LDA,(LOW);set lowest cyl
LDD,A;into counter
PUSHDE
PUSHHL
LDA,(CYCLES);get # cycles done
INCA
LD(CYCLES),A;update count
LDHL,CYC1
CALLSTUFF;update message
LDA,(HI);get top checked track
LDHL,CYC3
CALLSTUFF
LDA,(LOW);get lowest cylinder
LDHL,CYC2
CALLSTUFF
LDHL,3CC0H
LD(4020H),HL;set curposn
LDHL,CYC0
CALL@DSPLY
POPHL
POPDE
RET;loop to check it.
;
;Handle Directory Sectors Calls
;
DREADCALLRDSSECT;Read DIR sector
JRRET1;reenter code
DWRITECALLWRPROT;Write DIR sector
JRRET2;re-enter code.
;
;Check for <BREAK> Key Sbr.
;
CKKEYLDA,(KFLAG$);get flags
BIT0,A;<BREAK>?
RETZ;no,so continue
AND0FEH;reset flag
LD(KFLAG$),A
LDHL,BYMSG
CALL@DSPLY
JP@EXIT
;
;Sector I/O Error Handlers
;
WERRORLDHL,WEM
PUSHAF;Save error code
CALL@DSPLY
POPAF;Restore Error code
JP@ERROR
RERRORLDA,(DCYL);get DIR cyl #
CPD;Reading it?
JRZ,RR2;Use right call!!
CALLRDSECT;reread sector
JRRR1
RR2CALLRDSSECT;Reread DIR sector
RR1JPZ,RET1;reenter code
LDHL,REM
PUSHAF;save error code
CALL@DSPLY
POPAF;Restore error code
JP@ERROR
VPPUSHHL
PUSHDE
PUSHBC
LDHL,VPM
JRPJ1
WPPUSHHL
PUSHDE
PUSHBC
LDHL,WPM;Write header
JRPJ1
RPPUSHHL
PUSHDE
PUSHBC
LDHL,RPM;Read header
PJ1LDDE,PMSG
LDBC,7
LDIR;put header into message
POPBC
POPDE
PUSHDE
PUSHBC
LDA,D;get cyl #
LDHL,CPM
CALLSTUFF;stuff msg w/ digits
LDA,E;and sector #
LDHL,SPM
CALLSTUFF
LDHL,3D80H;force a specific
LD(4020H),HL;print position.
LDHL,PMSG;now print it
CALL@DSPLY
POPBC
POPDE
POPHL
RET
;
;Stuff Subroutine
;Stuffs 3 digits ==>HL
;with ASCII digits equal to contents of A
;
STUFFPUSHDE
LDE,A;E=dividend
LDA,100;A=divisor
CALLDIVEA;divide
ADDA,30H;convert to digit
LD(HL),A;stuff digit
LDA,10;A=divisor
CALLDIVEA;divide
ADDA,30H;make 10's digit
INCHL
LD(HL),A;stuff digit
INCHL
LDA,E;get remainder
ADDA,30H;make digit
LD(HL),A;and stuff
POPDE
RET;done!
;
;CkPar Sbr. checks input cyl and replaces with
;(HiCyl) if not in range 0=<P>=(HiCyl).
;
CKPARPUSHBC;save
LDB,A;b=Param value
LDA,(HICYL);highest valid #
SUBB;valid param?
LDA,(HICYL)
JPC,CK1;no! so use (Hicyl)!
LDA,B
CK1POPBC;restore BC
RET
VERSECPUSHHL
LDHL,$-$;Verify param goes here
VEREQU$-2
LDA,L;Verify option
CP0;selected?
POPHL;Restore pointer
RETZ;no, so skip it
CALLVP;print function
LDA,(DCYL)
CPD;Verifying DIR cly?
JRZ,VDS;if so, reread DIR sector
CALLVERIFY;verify the sector
RETZ;all ok, so go on...
VERERRPUSHAF;save flags
LDHL,VEM;print verify error
CALL@DSPLY;to crt
POPAF
JP@ERROR;jump to LDOS
VDSCALLRDSSECT
RETZ;reread is ok so ret
JRVERERR;process error!
;
;Text and Stack Area
;
MSG1DB1CH,1FH,0AH
DB'DriveCk  --  LDOS Disk Drive '
DB'Check Utility    Version 2.1'
DB0AH
DB'Enter Logical Drive Number to '
DB'Check  --> '
DB03H
INMSGDB0AH
DB'Illegal Drive Number!  Try Again.'
DB0DH
DEVMSGDB'Selected Drive is Write Protected '
DB'or NOT Ready!!!'
DB0DH
WEMDB'A WRITE ERROR has occurred!!'
DB0DH
REMDB'A READ ERROR has occurred!!'
DB0DH
VEMDB'A VERIFY ERROR has occurred!!'
DB0DH
PMSGDB'         Cylinder '
CPMDB32,32,32
DB', Sector '
SPMDB32,32,32
DB'.'
DB0DH
VPMDB'Verify '
WPMDB'Writing'
RPMDB'Reading'
CYC0DB'Checking Cylinders '
CYC2DB32,32,32
DB' through '
CYC3DB32,32,32
DB2EH,0AH
CYC1DB32,32,32
DB' Cycles have been Completed.'
DB0DH
BYMSGDB'DriveCk  Successfully  *Completed*'
DB0DH
PERMDB'Parameter Error!!'
DB0DH
ABORTMDB'DriveCk  Execution  *Aborted*'
DB0DH
HICYLDB00H;Set to DCT track count
HISECTDB00H;Set to DCT sector count
HIDB00H;User selected top track
LOWDB00H;user selected low track
DCYLDB00H;DIR Cyl goes here.
DRIVEDB00H;Drive being checked put here
CYCLESDB0FFH;# cycles done storage
BUFFRDC100H,00H;sector buffer
PTABLEDB'LOW   '
DWLO
DB'L     '
DWLO
DB'LO    '
DWLO
DB'HIGH  '
DWHIGH
DB'HI    '
DWHIGH
DB'H     '
DWHIGH
DB'VERIFY'
DWVER
DB'VER   '
DWVER
DB'V     '
DWVER
DB'DRIVE '
DWDRV
DB'D     '
DWDRV
DW0000H;End of Table
DC55H,00H;Stack space
STACKDW0000H
ENDDRIVECK
